<?php
/*--------------------------------------------------------------------
 ServiceProvider.php 2020-3-11
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\Representation\Id;

use Doctrine\DBAL\Connection;
use Gambio\Core\Event\EventListenerProvider;
use Gambio\Shop\Properties\SellingUnitImages\Database\Repository\Helpers\CombisIdIdentifier;
use Gambio\Shop\Properties\SellingUnitImages\Database\Repository\Helpers\CombisIdIdentifierInterface;
use Gambio\Shop\Attributes\Representation\Id\Listener\OnPresentSellingUnitIdEventListener;
use Gambio\Shop\Attributes\Representation\Id\Repository\Factories\PresentationIdFactory;
use Gambio\Shop\Attributes\Representation\Id\Repository\Factories\PresentationIdFactoryInterface;
use Gambio\Shop\Attributes\Representation\Id\Repository\Readers\Reader;
use Gambio\Shop\Attributes\Representation\Id\Repository\Readers\ReaderInterface;
use Gambio\Shop\Attributes\Representation\Id\Repository\Repository;
use Gambio\Shop\Attributes\Representation\Id\Repository\RepositoryInterface;
use Gambio\Shop\SellingUnit\Presentation\Events\OnPresentSellingUnitIdEvent;
use League\Container\Container;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;
use PropertiesDataAgent;

/**
 * Class ServiceProvider
 * @package Gambio\Shop\Attributes\Representation\Id
 * @property-read Container $container
 */
class ServiceProvider extends AbstractServiceProvider implements BootableServiceProviderInterface
{
    /**
     * @var string[]
     */
    protected $provides = [
        OnPresentSellingUnitIdEventListener::class
    ];
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->container->share(ReadServiceInterface::class, ReadService::class)
            ->addArgument(RepositoryInterface::class);
        
        $this->container->share(RepositoryInterface::class, Repository::class)
            ->addArgument(ReaderInterface::class)
            ->addArgument(PresentationIdFactoryInterface::class)
            ->addArgument(CombisIdIdentifierInterface::class);
        
        $this->container->share(ReaderInterface::class, Reader::class)
            ->addArgument(Connection::class);
        
        $this->container->share(PresentationIdFactoryInterface::class, PresentationIdFactory::class);
        
        $this->container->share(CombisIdIdentifierInterface::class, CombisIdIdentifier::class)
            ->addArgument(PropertiesDataAgent::class);
        
        $this->container->share(PropertiesDataAgent::class);
        
        $this->container->share(OnPresentSellingUnitIdEventListener::class)
            ->addArgument(ReadServiceInterface::class);
    }
    
    
    
    /**
     * @inheritDoc
     */
    public function boot(): void
    {
        /** @var EventListenerProvider $listenerProvider */
        $listenerProvider = $this->container->get(EventListenerProvider::class);
        $listenerProvider->attachListener(OnPresentSellingUnitIdEvent::class, OnPresentSellingUnitIdEventListener::class);
    }
}